DROP TABLE IF EXISTS `activity_logs`;

CREATE TABLE `activity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `action` varchar(255) NOT NULL,
  `target_table` varchar(100) DEFAULT NULL,
  `target_id` int(11) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `activity_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `activity_logs` VALUES("1","1","User logged in","","","","::1","2025-09-20 03:33:31","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("2","1","User logged out","","","","::1","2025-09-20 03:35:07","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("3","2","User logged in","","","","::1","2025-09-20 03:35:51","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("4","2","User logged out","","","","::1","2025-09-20 03:37:44","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("7","2","User logged in","","","","::1","2025-09-20 04:31:18","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("8","2","User logged out","","","","::1","2025-09-20 05:30:30","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("13","2","User logged in","","","","::1","2025-09-20 05:47:00","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("14","2","Created treatment plan","","","Patient ID: 1","::1","2025-09-20 05:47:53","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("20","2","User logged out","","","","::1","2025-09-21 21:39:46","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("21","2","User logged in","","","","::1","2025-09-21 21:39:56","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("23","1","User logged in","","","","::1","2025-09-22 23:22:12","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("24","1","User logged out","","","","::1","2025-09-22 23:23:51","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("25","2","User logged in","","","","::1","2025-09-22 23:24:35","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("28","2","Reviewed PCOS assessment","","","Assessment ID: 1","::1","2025-09-23 15:38:32","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("30","1","User logged in","","","","::1","2025-09-25 04:01:58","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("32","2","User logged in","","","","::1","2025-09-25 04:07:37","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("33","2","Added follicle record","","","Patient ID: 3, PCOS Score: 9","::1","2025-09-25 04:36:12","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("34","2","Edited follicle record","","","Record ID: 1","::1","2025-09-25 04:44:42","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("37","2","Added follicle record","","","Patient ID: 2, PCOS Score: 9","::1","2025-09-25 10:21:00","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("38","2","Added educational resource","","","Title: PCOS_101","::1","2025-09-25 14:05:36","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("41","2","Updated educational resource","","","ID: 0","::1","2025-09-25 17:42:06","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("42","2","User logged in","","","","::1","2025-09-28 16:36:12","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("43","2","User logged out","","","","::1","2025-09-29 12:21:01","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("44","2","User logged in","","","","::1","2025-09-29 12:23:25","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("63","2","User logged in","","","","::1","2025-10-02 08:56:30","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("64","2","Reviewed PCOS assessment","","","Assessment ID: 3","::1","2025-10-02 08:58:33","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("65","2","Scheduled appointment","","","Patient ID: 4, Date: 2025-10-03","::1","2025-10-02 09:04:01","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("66","1","User logged in","","","","::1","2025-10-13 15:08:19","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("67","1","User logged out","","","","::1","2025-10-13 15:08:53","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("68","2","User logged in","","","","::1","2025-10-13 15:09:14","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("72","2","Reviewed PCOS assessment","","","Assessment ID: 2","::1","2025-10-13 19:14:49","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("75","2","User logged in","","","","::1","2025-10-15 16:48:15","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("76","2","User logged in","","","","::1","2025-10-15 16:55:41","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("77","2","User logged in","","","","::1","2025-10-15 16:56:23","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("78","2","User logged in","","","","::1","2025-10-15 16:56:25","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("79","2","User logged in","","","","::1","2025-10-15 16:56:25","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("80","2","User logged in","","","","::1","2025-10-15 16:56:46","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("81","2","User logged in","","","","::1","2025-10-15 16:56:48","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("82","2","User logged in","","","","::1","2025-10-15 16:57:46","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("83","2","User logged in","","","","::1","2025-10-15 16:59:56","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("84","2","User logged in","","","","::1","2025-10-15 16:59:58","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("85","2","User logged in","","","","::1","2025-10-15 16:59:59","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("86","2","User logged in","","","","::1","2025-10-15 16:59:59","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("87","2","User logged in","","","","::1","2025-10-15 17:00:00","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("88","2","User logged in","","","","::1","2025-10-15 17:00:00","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("89","2","User logged in","","","","::1","2025-10-15 17:00:01","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("90","2","User logged in","","","","::1","2025-10-15 17:00:01","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("91","2","User logged in","","","","::1","2025-10-15 17:00:02","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("92","2","User logged in","","","","::1","2025-10-15 17:00:02","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("93","2","User logged in","","","","::1","2025-10-15 17:00:03","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("94","2","User logged in","","","","::1","2025-10-15 17:00:03","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("95","2","User logged in","","","","::1","2025-10-15 17:00:04","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("96","2","User logged in","","","","::1","2025-10-15 17:00:06","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("97","2","User logged in","","","","::1","2025-10-15 17:00:07","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("98","2","User logged in","","","","::1","2025-10-15 17:00:08","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("99","2","User logged in","","","","::1","2025-10-15 17:00:11","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("100","2","User logged in","","","","::1","2025-10-15 17:03:10","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("102","2","Added educational resource","","","Title: PCOS SUPER FILE","::1","2025-10-15 17:59:18","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("103","2","Added educational resource","","","Title: PCOS SUPER FILE","::1","2025-10-15 18:03:42","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("104","2","Added educational resource","","","Title: PCOS SUPER FILE","::1","2025-10-15 18:08:44","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("105","2","Added educational resource","","","Title: PCOS SUPER FILE","::1","2025-10-15 18:09:01","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("107","2","Updated educational resource","","","ID: 1","::1","2025-10-16 09:10:57","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("108","2","Updated educational resource","","","ID: 1","::1","2025-10-16 09:25:51","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("109","2","Updated educational resource","","","ID: 1","::1","2025-10-16 09:31:07","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("110","2","Deleted educational resource","","","ID: 5","::1","2025-10-16 09:32:07","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("111","2","Deleted educational resource","","","ID: 4","::1","2025-10-16 09:32:13","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("112","2","Deleted educational resource","","","ID: 10","::1","2025-10-16 09:32:16","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("113","2","Deleted educational resource","","","ID: 9","::1","2025-10-16 09:32:20","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("114","2","Deleted educational resource","","","ID: 8","::1","2025-10-16 09:32:23","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("115","2","Deleted educational resource","","","ID: 6","::1","2025-10-16 09:32:27","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("116","2","Deleted educational resource","","","ID: 7","::1","2025-10-16 09:32:30","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("117","2","Deleted educational resource","","","ID: 1","::1","2025-10-16 09:32:33","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("118","2","Deleted educational resource","","","ID: 3","::1","2025-10-16 09:32:51","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("119","2","Deleted educational resource","","","ID: 2","::1","2025-10-16 09:32:57","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("120","2","Added educational resource","","","Title: Understanding PCOS","::1","2025-10-16 09:37:21","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("125","2","User logged in","","","","::1","2025-10-16 19:00:01","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("130","2","User logged in","","","","::1","2025-10-20 11:45:53","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("141","2","User logged in","","","","::1","2025-10-20 16:50:27","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("145","12","User registered","","","","::1","2025-10-30 11:18:14","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("146","12","User logged in","","","","::1","2025-10-30 11:18:35","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("147","2","User logged in","","","","::1","2025-10-30 11:19:45","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("148","12","Requested appointment","","","Doctor ID: 1, Date: 2025-10-31","::1","2025-10-30 11:32:16","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("149","12","User logged out","","","","::1","2025-10-30 11:49:47","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("169","12","User logged in","","","","::1","2025-10-30 13:48:25","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("170","12","User logged out","","","","::1","2025-10-30 14:23:56","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("171","12","User logged in","","","","::1","2025-10-30 14:29:30","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("173","12","User logged in","","","","::1","2025-11-02 19:56:18","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("174","12","Completed simple PCOS assessment","","","Score: 5, Risk: Moderate","::1","2025-11-02 19:56:37","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("175","12","Completed simple PCOS assessment","","","Score: 3, Risk: Low","::1","2025-11-02 19:58:00","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("181","12","User logged out","","","","::1","2025-11-03 19:39:18","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("186","12","User logged in","","","","::1","2025-11-03 20:39:12","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("196","12","User logged out","","","","::1","2025-11-04 00:47:07","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("210","1","User logged in","","","","::1","2025-11-04 18:57:55","2025-11-04 19:03:37");
INSERT INTO `activity_logs` VALUES("211","1","Updated user status to inactive for user ID: 15","","","","::1","2025-11-04 19:23:34","2025-11-04 19:23:34");
INSERT INTO `activity_logs` VALUES("212","1","Updated user status to active for user ID: 15","","","","::1","2025-11-04 19:23:40","2025-11-04 19:23:40");
INSERT INTO `activity_logs` VALUES("213","1","Updated roles for user ID: 12","","","","::1","2025-11-04 19:24:16","2025-11-04 19:24:16");
INSERT INTO `activity_logs` VALUES("215","1","User logged in","","","","::1","2025-11-04 19:25:11","2025-11-04 19:25:11");
INSERT INTO `activity_logs` VALUES("216","1","User logged out","","","","::1","2025-11-04 19:25:25","2025-11-04 19:25:25");
INSERT INTO `activity_logs` VALUES("217","12","User logged in","","","","::1","2025-11-04 19:25:36","2025-11-04 19:25:36");
INSERT INTO `activity_logs` VALUES("218","12","Completed simple PCOS assessment","","","Score: 0, Risk: Minimal","::1","2025-11-04 19:25:52","2025-11-04 19:25:52");
INSERT INTO `activity_logs` VALUES("219","12","User logged out","","","","::1","2025-11-04 19:34:36","2025-11-04 19:34:36");
INSERT INTO `activity_logs` VALUES("224","16","User registered","","","","::1","2025-11-04 19:37:29","2025-11-04 19:37:29");
INSERT INTO `activity_logs` VALUES("225","16","User logged in","","","","::1","2025-11-04 19:37:37","2025-11-04 19:37:37");
INSERT INTO `activity_logs` VALUES("226","16","Completed simple PCOS assessment","","","Score: 9, Risk: High","::1","2025-11-04 19:37:52","2025-11-04 19:37:52");
INSERT INTO `activity_logs` VALUES("227","1","Deleted user ID: 5","","","","::1","2025-11-04 19:42:12","2025-11-04 19:42:12");
INSERT INTO `activity_logs` VALUES("228","1","Deleted user ID: 13","","","","::1","2025-11-04 19:42:18","2025-11-04 19:42:18");
INSERT INTO `activity_logs` VALUES("229","1","Deleted user ID: 14","","","","::1","2025-11-04 19:42:22","2025-11-04 19:42:22");
INSERT INTO `activity_logs` VALUES("230","1","Deleted user ID: 15","","","","::1","2025-11-04 19:42:31","2025-11-04 19:42:31");
INSERT INTO `activity_logs` VALUES("231","1","Deleted user ID: 9","","","","::1","2025-11-04 19:42:35","2025-11-04 19:42:35");
INSERT INTO `activity_logs` VALUES("232","1","Deleted user ID: 10","","","","::1","2025-11-04 19:42:39","2025-11-04 19:42:39");
INSERT INTO `activity_logs` VALUES("233","1","Deleted user ID: 7","","","","::1","2025-11-04 19:42:43","2025-11-04 19:42:43");
INSERT INTO `activity_logs` VALUES("234","1","Deleted user ID: 6","","","","::1","2025-11-04 19:42:47","2025-11-04 19:42:47");
INSERT INTO `activity_logs` VALUES("235","1","Deleted user ID: 4","","","","::1","2025-11-04 19:42:51","2025-11-04 19:42:51");
INSERT INTO `activity_logs` VALUES("236","1","Deleted user ID: 8","","","","::1","2025-11-04 19:42:55","2025-11-04 19:42:55");
INSERT INTO `activity_logs` VALUES("237","1","Deleted user ID: 11","","","","::1","2025-11-04 19:43:00","2025-11-04 19:43:00");
INSERT INTO `activity_logs` VALUES("238","1","Deleted user ID: 3","","","","::1","2025-11-04 19:43:07","2025-11-04 19:43:07");



DROP TABLE IF EXISTS `appointments`;

CREATE TABLE `appointments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `appointment_date` date NOT NULL,
  `appointment_time` time NOT NULL,
  `reason` text DEFAULT NULL,
  `status` enum('scheduled','completed','cancelled','no_show') DEFAULT 'scheduled',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor_id` (`doctor_id`),
  CONSTRAINT `appointments_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointments_ibfk_2` FOREIGN KEY (`doctor_id`) REFERENCES `doctors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `appointments` VALUES("4","6","1","2025-10-31","11:34:00","New","","","2025-10-30 11:32:16","2025-10-30 11:32:16");



DROP TABLE IF EXISTS `assessment_exports`;

CREATE TABLE `assessment_exports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `export_type` varchar(20) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `assessment_exports_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `assessments`;

CREATE TABLE `assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `age_at_menarche` int(11) DEFAULT 0,
  `height` decimal(5,2) DEFAULT 0.00,
  `weight` decimal(5,2) DEFAULT 0.00,
  `waist_hip_ratio` decimal(5,2) DEFAULT 0.00,
  `systolic_bp` int(11) DEFAULT 0,
  `diastolic_bp` int(11) DEFAULT 0,
  `total_cholesterol` decimal(5,2) DEFAULT 0.00,
  `ldl_cholesterol` decimal(5,2) DEFAULT 0.00,
  `hdl_cholesterol` decimal(5,2) DEFAULT 0.00,
  `triglycerides` decimal(5,2) DEFAULT 0.00,
  `family_history_cardiovascular` enum('yes','no') DEFAULT 'no',
  `libido_changes` enum('none','decreased','increased') DEFAULT 'none',
  `sleep_quality` enum('good','fair','poor') DEFAULT 'fair',
  `fatigue_chronic` enum('yes','no') DEFAULT 'no',
  `weight_gain_difficulty` enum('yes','no') DEFAULT 'no',
  `assessment_date` date DEFAULT NULL,
  `physician_reviewed` tinyint(1) DEFAULT 0,
  `physician_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `doctors`;

CREATE TABLE `doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `specialization` varchar(100) DEFAULT NULL,
  `sub_specialization` varchar(100) DEFAULT NULL,
  `license_number` varchar(50) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `experience_years` int(11) DEFAULT NULL,
  `qualifications` text DEFAULT NULL,
  `clinic_address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `doctors_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `doctors` VALUES("1","2","Dr. John Smith","Reproductive Endocrinology","","MD12345","+1234567890","","","","2025-09-20 03:28:08","2025-09-20 03:28:08");



DROP TABLE IF EXISTS `follicle_examinations`;

CREATE TABLE `follicle_examinations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `examination_date` date NOT NULL,
  `ovarian_morphology` varchar(100) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `pcos_score` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `follicle_records`;

CREATE TABLE `follicle_records` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `examination_date` date NOT NULL,
  `follicle_count` int(11) DEFAULT NULL,
  `antral_follicle_count` int(11) DEFAULT NULL COMMENT 'Total AFC',
  `follicle_size` varchar(100) DEFAULT NULL,
  `follicle_location` varchar(100) DEFAULT NULL,
  `follicle_size_distribution` text DEFAULT NULL COMMENT 'JSON array of follicle sizes',
  `ovarian_stroma_echogenicity` enum('normal','increased','hyperechogenic') DEFAULT 'normal',
  `pcos_morphology_score` int(11) DEFAULT NULL COMMENT 'Morphology scoring',
  `fsh_level` decimal(10,2) DEFAULT NULL,
  `lh_level` decimal(10,2) DEFAULT NULL,
  `amh_level` decimal(10,2) DEFAULT NULL,
  `ovarian_volume_right` decimal(5,2) DEFAULT NULL COMMENT 'mL',
  `ovarian_volume_left` decimal(5,2) DEFAULT NULL COMMENT 'mL',
  `estradiol_level` decimal(10,2) DEFAULT NULL,
  `progesterone_level` decimal(10,2) DEFAULT NULL,
  `insulin_level` decimal(8,2) DEFAULT NULL COMMENT 'μU/mL',
  `glucose_level` decimal(6,2) DEFAULT NULL COMMENT 'mg/dL',
  `homa_ir_score` decimal(6,3) DEFAULT NULL COMMENT 'HOMA-IR calculation',
  `diagnosis` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `pcos_score` varchar(50) DEFAULT NULL,
  `pcos_risk_level` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `follicle_count_right` int(11) DEFAULT NULL,
  `follicle_size_right` varchar(50) DEFAULT NULL,
  `follicle_count_left` int(11) DEFAULT NULL,
  `follicle_size_left` varchar(50) DEFAULT NULL,
  `endometrial_thickness` decimal(4,2) DEFAULT NULL COMMENT 'mm',
  `dominant_follicle_right` tinyint(1) DEFAULT 0,
  `dominant_follicle_left` tinyint(1) DEFAULT 0,
  `dominant_follicle_size` decimal(4,1) DEFAULT NULL,
  `ovary_volume_right` decimal(5,2) DEFAULT NULL,
  `ovary_volume_left` decimal(5,2) DEFAULT NULL,
  `testosterone_level` decimal(8,2) DEFAULT NULL,
  `tsh_level` decimal(8,2) DEFAULT NULL,
  `prolactin_level` float DEFAULT NULL,
  `fasting_glucose` float DEFAULT NULL,
  `fasting_insulin` float DEFAULT NULL,
  `hba1c` float DEFAULT NULL,
  `treatment_plan` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor_id` (`doctor_id`),
  CONSTRAINT `follicle_records_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `follicle_records_ibfk_2` FOREIGN KEY (`doctor_id`) REFERENCES `doctors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `notifications`;

CREATE TABLE `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `sender_id` int(11) DEFAULT NULL,
  `type` enum('assessment','appointment','message','record') NOT NULL,
  `message` text NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `idx_sender_id` (`sender_id`),
  KEY `idx_sender_read` (`sender_id`,`is_read`),
  CONSTRAINT `fk_notifications_sender` FOREIGN KEY (`sender_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `notifications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `patient_goals`;

CREATE TABLE `patient_goals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `target_date` date DEFAULT NULL,
  `status` enum('pending','completed') DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `patient_goals_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `patient_reports`;

CREATE TABLE `patient_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `report_title` varchar(255) NOT NULL,
  `report_content` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor_id` (`doctor_id`),
  CONSTRAINT `patient_reports_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_reports_ibfk_2` FOREIGN KEY (`doctor_id`) REFERENCES `doctors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `patient_resource_access`;

CREATE TABLE `patient_resource_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `resource_id` int(11) NOT NULL,
  `access_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `completion_status` enum('started','in_progress','completed') DEFAULT 'started',
  `rating` int(11) DEFAULT NULL COMMENT '1-5 stars',
  `feedback` text DEFAULT NULL,
  `assigned_by_doctor` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `resource_id` (`resource_id`),
  CONSTRAINT `patient_resource_access_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_resource_access_ibfk_2` FOREIGN KEY (`resource_id`) REFERENCES `pcos_education_resources` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `patients`;

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT 'Unknown Patient',
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `age` int(11) NOT NULL,
  `gender` enum('male','female','other') NOT NULL,
  `has_pcos_diagnosis` enum('yes','no') NOT NULL DEFAULT 'no',
  `subscription_status` enum('active','inactive','expired') NOT NULL DEFAULT 'inactive',
  `subscription_end_date` date DEFAULT NULL,
  `pregnancy_status` enum('unknown','not_pregnant','pregnant','trying_to_conceive') DEFAULT 'unknown',
  `contact` varchar(20) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `emergency_contact` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `height` decimal(5,2) DEFAULT NULL,
  `weight` decimal(5,2) DEFAULT NULL,
  `bmi` decimal(5,2) DEFAULT NULL,
  `blood_type` varchar(5) DEFAULT NULL,
  `ethnicity` varchar(50) DEFAULT NULL,
  `occupation` varchar(100) DEFAULT NULL,
  `education_level` varchar(50) DEFAULT NULL,
  `medical_history` text DEFAULT NULL,
  `allergies` text DEFAULT NULL,
  `current_medications` text DEFAULT NULL,
  `menstrual_cycle_length` int(11) DEFAULT NULL,
  `last_menstrual_period` date DEFAULT NULL,
  `age_at_menarche` int(11) DEFAULT NULL,
  `family_history_pcos` tinyint(1) DEFAULT 0,
  `family_history_diabetes` tinyint(1) DEFAULT 0,
  `family_history_infertility` tinyint(1) DEFAULT 0,
  `smoking_status` enum('never','former','current') DEFAULT 'never',
  `alcohol_consumption` enum('none','occasional','moderate','heavy') DEFAULT 'none',
  `exercise_frequency` enum('sedentary','light','moderate','vigorous') DEFAULT 'sedentary',
  `stress_level` enum('low','moderate','high','severe') DEFAULT 'moderate',
  `sleep_quality` enum('poor','fair','good','excellent') DEFAULT 'fair',
  `contraceptive_use` varchar(100) DEFAULT NULL,
  `pregnancy_history` text DEFAULT NULL COMMENT 'JSON array of pregnancy details',
  `fertility_concerns` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `doctor_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `fk_patient_doctor` (`doctor_id`),
  CONSTRAINT `fk_patient_doctor` FOREIGN KEY (`doctor_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `patients_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patients` VALUES("6","12","Cynthia Doe2","","","35","female","yes","inactive","","trying_to_conceive","","","","Port Harcourt","","","","","","","","","","","","","","","","0","0","0","never","none","sedentary","moderate","fair","","","0","2025-10-30 11:18:14","2025-10-30 11:18:14","");
INSERT INTO `patients` VALUES("10","16","Efiok James Akpan","","","34","female","yes","inactive","","pregnant","","","","Port Harcourt","","","","","","","","","","Nothing wrong","","","","","","0","0","0","never","none","sedentary","moderate","fair","","","0","2025-11-04 19:37:29","2025-11-04 19:37:29","");



DROP TABLE IF EXISTS `pcos_assessments`;

CREATE TABLE `pcos_assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `irregular_cycles` enum('yes','no') DEFAULT 'no',
  `hirsutism` enum('yes','no') DEFAULT 'no',
  `acne` enum('yes','no') DEFAULT 'no',
  `hair_loss` enum('yes','no') DEFAULT 'no',
  `weight_issues` enum('yes','no') DEFAULT 'no',
  `skin_tags` enum('yes','no') DEFAULT 'no',
  `dark_skin_patches` enum('yes','no') DEFAULT 'no',
  `family_history` enum('yes','no') DEFAULT 'no',
  `pcos_score` int(11) DEFAULT 0,
  `pcos_risk_level` enum('Minimal','Low','Moderate','High') DEFAULT 'Minimal',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `pcos_assessments_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `pcos_assessments` VALUES("11","6","no","yes","yes","no","no","yes","yes","no","5","Moderate","2025-11-02 19:56:37");
INSERT INTO `pcos_assessments` VALUES("12","6","no","yes","yes","no","no","no","no","no","3","Low","2025-11-02 19:58:00");
INSERT INTO `pcos_assessments` VALUES("26","6","no","no","no","no","no","no","no","no","0","Minimal","2025-11-04 19:25:52");
INSERT INTO `pcos_assessments` VALUES("27","10","yes","yes","yes","yes","yes","no","no","no","9","High","2025-11-04 19:37:52");



DROP TABLE IF EXISTS `pcos_comprehensive_assessments`;

CREATE TABLE `pcos_comprehensive_assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `menstrual_irregularities` enum('yes','no') DEFAULT 'no',
  `cycle_length` int(11) DEFAULT NULL,
  `oligomenorrhea` enum('yes','no') DEFAULT 'no',
  `amenorrhea` enum('yes','no') DEFAULT 'no',
  `age_at_menarche` int(11) DEFAULT NULL,
  `last_menstrual_period` date DEFAULT NULL,
  `hirsutism_score` int(11) DEFAULT 0,
  `acne_severity` enum('none','mild','moderate','severe') DEFAULT 'none',
  `androgenic_alopecia` enum('yes','no') DEFAULT 'no',
  `voice_changes` enum('yes','no') DEFAULT 'no',
  `height` decimal(5,2) DEFAULT NULL,
  `weight` decimal(5,2) DEFAULT NULL,
  `bmi` decimal(5,2) DEFAULT NULL,
  `waist_circumference` decimal(5,2) DEFAULT NULL,
  `insulin_resistance` enum('yes','no') DEFAULT 'no',
  `diabetes_risk` enum('yes','no') DEFAULT 'no',
  `total_testosterone` decimal(8,2) DEFAULT NULL COMMENT 'ng/dL',
  `free_testosterone` decimal(8,2) DEFAULT NULL COMMENT 'pg/mL',
  `dhea_s` decimal(8,2) DEFAULT NULL COMMENT 'μg/dL',
  `androstenedione` decimal(8,2) DEFAULT NULL COMMENT 'ng/dL',
  `lh_level` decimal(8,2) DEFAULT NULL COMMENT 'mIU/mL',
  `fsh_level` decimal(8,2) DEFAULT NULL COMMENT 'mIU/mL',
  `lh_fsh_ratio` decimal(5,2) DEFAULT NULL,
  `glucose_tolerance` enum('normal','impaired','diabetic') DEFAULT 'normal',
  `hba1c` decimal(4,2) DEFAULT NULL COMMENT 'percentage',
  `fasting_glucose` decimal(6,2) DEFAULT NULL COMMENT 'mg/dL',
  `fasting_insulin` decimal(8,2) DEFAULT NULL COMMENT 'μU/mL',
  `homa_ir` decimal(6,3) DEFAULT NULL COMMENT 'HOMA-IR score',
  `amh_level` decimal(8,2) DEFAULT NULL COMMENT 'ng/mL',
  `prolactin_level` decimal(8,2) DEFAULT NULL COMMENT 'ng/mL',
  `thyroid_stimulating_hormone` decimal(8,2) DEFAULT NULL COMMENT 'mIU/L',
  `cortisol_level` decimal(8,2) DEFAULT NULL COMMENT 'μg/dL',
  `ovarian_volume_right` decimal(5,2) DEFAULT NULL COMMENT 'mL',
  `ovarian_volume_left` decimal(5,2) DEFAULT NULL COMMENT 'mL',
  `ovarian_volume` decimal(5,2) DEFAULT NULL COMMENT 'average mL',
  `follicle_count_right` int(11) DEFAULT NULL COMMENT '2-9mm follicles',
  `follicle_count_left` int(11) DEFAULT NULL COMMENT '2-9mm follicles',
  `total_follicle_count` int(11) DEFAULT NULL,
  `ovarian_stroma` enum('normal','increased','hyperechogenic') DEFAULT 'normal',
  `endometrial_thickness` decimal(4,2) DEFAULT NULL COMMENT 'mm',
  `family_history_pcos` enum('yes','no') DEFAULT 'no',
  `family_history_diabetes` enum('yes','no') DEFAULT 'no',
  `family_history_metabolic` enum('yes','no') DEFAULT 'no',
  `family_history_infertility` enum('yes','no') DEFAULT 'no',
  `family_history_cardiovascular` enum('yes','no') DEFAULT 'no',
  `skin_tags` enum('yes','no') DEFAULT 'no',
  `acanthosis_nigricans` enum('yes','no') DEFAULT 'no',
  `mood_changes` enum('yes','no') DEFAULT 'no',
  `sleep_apnea` enum('yes','no') DEFAULT 'no',
  `fatigue_chronic` enum('yes','no') DEFAULT 'no',
  `weight_gain_difficulty` enum('yes','no') DEFAULT 'no',
  `total_cholesterol` decimal(6,2) DEFAULT NULL COMMENT 'mg/dL',
  `ldl_cholesterol` decimal(6,2) DEFAULT NULL COMMENT 'mg/dL',
  `hdl_cholesterol` decimal(6,2) DEFAULT NULL COMMENT 'mg/dL',
  `triglycerides` decimal(6,2) DEFAULT NULL COMMENT 'mg/dL',
  `sleep_quality` enum('excellent','good','fair','poor') DEFAULT 'good',
  `systolic_bp` int(11) DEFAULT NULL COMMENT 'mmHg',
  `diastolic_bp` int(11) DEFAULT NULL COMMENT 'mmHg',
  `rotterdam_score` int(11) DEFAULT 0 COMMENT 'Rotterdam criteria score (0-6)',
  `pcos_probability` decimal(5,2) DEFAULT 0.00 COMMENT 'Probability percentage',
  `diagnosis_category` varchar(100) DEFAULT NULL,
  `risk_level` enum('Low','Moderate','Moderate-High','High') DEFAULT 'Low',
  `total_assessment_score` decimal(6,2) DEFAULT 0.00,
  `criteria_met` text DEFAULT NULL COMMENT 'JSON array of met criteria',
  `additional_risk_factors` text DEFAULT NULL COMMENT 'JSON array of risk factors',
  `assessment_date` date NOT NULL,
  `assessment_type` enum('self','clinical','comprehensive') DEFAULT 'comprehensive',
  `physician_reviewed` tinyint(1) DEFAULT 0,
  `physician_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `waist_hip_ratio` decimal(5,2) DEFAULT NULL,
  `blood_pressure_systolic` int(11) DEFAULT NULL,
  `blood_pressure_diastolic` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `assessment_date` (`assessment_date`),
  KEY `diagnosis_category` (`diagnosis_category`),
  KEY `idx_pcos_assessments_probability` (`pcos_probability`),
  KEY `idx_pcos_assessments_risk_level` (`risk_level`),
  KEY `idx_pcos_assessments_date` (`assessment_date`),
  KEY `idx_patient_created` (`patient_id`,`created_at`),
  KEY `idx_risk_level` (`risk_level`),
  KEY `idx_probability` (`pcos_probability`),
  KEY `idx_sleep_quality` (`sleep_quality`),
  KEY `idx_assessments_patient_date` (`patient_id`,`assessment_date`),
  CONSTRAINT `pcos_comprehensive_assessments_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `pcos_comprehensive_assessments` VALUES("7","6","yes","28","no","no","16","","4","moderate","yes","yes","177.00","89.00","28.40","90.00","no","no","15.00","7.00","333.00","7.00","8.00","8.00","3.00","impaired","5.00","50.00","7.00","0.864","","","","","","","0.00","0","0","0","normal","","no","no","no","no","no","no","no","no","no","no","no","300.00","99.00","65.00","150.00","good","140","99","5","89.50","PCOS Diagnosed (Rotterdam Criteria)","High","6.50","[\"Oligo\\/Anovulation\",\"Hyperandrogenism\"]","","2025-10-30","comprehensive","0","","2025-10-30 11:36:48","2025-10-30 11:36:48","0.27","","");
INSERT INTO `pcos_comprehensive_assessments` VALUES("13","10","yes","24","no","no","23","","4","mild","yes","yes","190.00","80.00","22.20","90.00","no","no","15.00","8.00","400.00","7.00","9.00","5.00","3.00","normal","7.00","100.00","50.00","12.346","","","","","","","0.00","0","0","0","normal","","no","no","no","no","no","no","no","no","no","no","no","700.00","200.00","0.00","0.00","good","170","89","5","88.00","PCOS Diagnosed (Rotterdam Criteria)","High","6.00","[\"Oligo\\/Anovulation\",\"Hyperandrogenism\"]","","2025-11-04","comprehensive","0","","2025-11-04 19:40:29","2025-11-04 19:40:29","0.45","","");



DROP TABLE IF EXISTS `pcos_education_resources`;

CREATE TABLE `pcos_education_resources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `category` enum('general','nutrition','exercise','medical','mental_health','fertility') NOT NULL,
  `resource_type` enum('article','video','pdf','external_link','infographic') NOT NULL,
  `content` text DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `external_url` varchar(500) DEFAULT NULL,
  `target_audience` enum('patient','doctor','both') DEFAULT 'patient',
  `difficulty_level` enum('beginner','intermediate','advanced') DEFAULT 'beginner',
  `estimated_read_time` int(11) DEFAULT NULL COMMENT 'minutes',
  `tags` text DEFAULT NULL COMMENT 'JSON array of tags',
  `is_active` tinyint(1) DEFAULT 1,
  `view_count` int(11) DEFAULT 0,
  `display_order` int(11) DEFAULT 0,
  `created_by` int(11) DEFAULT NULL,
  `assigned_by_doctor` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `category` (`category`),
  KEY `resource_type` (`resource_type`),
  KEY `target_audience` (`target_audience`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `pcos_education_resources_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `pcos_education_resources` VALUES("11","Understanding PCOS","general","video","Tips for Best Use
\n
\nAlways log out after use.
\n
\nUse Chrome or Edge on desktop for best performance.
\n
\nDo not share login credentials.
\n
\nClear cache if pages don’t load properly.","uploads/resources/resource_68f0aec1944731.13904903.mp4","","patient","beginner","","","1","2","0","1","","2025-10-16 09:37:21","2025-10-30 12:43:07");



DROP TABLE IF EXISTS `pcos_interventions`;

CREATE TABLE `pcos_interventions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assessment_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `intervention_type` enum('medical','nutritional','exercise','monitoring','lifestyle') NOT NULL,
  `intervention_text` text NOT NULL,
  `dosage_instructions` text DEFAULT NULL,
  `frequency` varchar(100) DEFAULT NULL,
  `duration_weeks` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` enum('recommended','prescribed','active','completed','discontinued') DEFAULT 'recommended',
  `effectiveness_rating` int(11) DEFAULT NULL COMMENT '1-10 scale',
  `side_effects` text DEFAULT NULL,
  `patient_compliance` enum('excellent','good','fair','poor') DEFAULT NULL,
  `physician_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `assessment_id` (`assessment_id`),
  KEY `patient_id` (`patient_id`),
  KEY `intervention_type` (`intervention_type`),
  KEY `idx_interventions_type_status` (`intervention_type`,`status`),
  CONSTRAINT `pcos_interventions_ibfk_1` FOREIGN KEY (`assessment_id`) REFERENCES `pcos_comprehensive_assessments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pcos_interventions_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `pcos_lab_interpretations`;

CREATE TABLE `pcos_lab_interpretations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `assessment_id` int(11) DEFAULT NULL,
  `lab_date` date NOT NULL,
  `test_name` varchar(100) NOT NULL,
  `test_value` decimal(10,3) NOT NULL,
  `reference_range_min` decimal(10,3) DEFAULT NULL,
  `reference_range_max` decimal(10,3) DEFAULT NULL,
  `unit` varchar(20) DEFAULT NULL,
  `interpretation` enum('normal','borderline','abnormal','critical') NOT NULL,
  `clinical_significance` text DEFAULT NULL,
  `trend_direction` enum('improving','stable','worsening') DEFAULT NULL,
  `action_required` tinyint(1) DEFAULT 0,
  `physician_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `assessment_id` (`assessment_id`),
  KEY `lab_date` (`lab_date`),
  KEY `test_name` (`test_name`),
  CONSTRAINT `pcos_lab_interpretations_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pcos_lab_interpretations_ibfk_2` FOREIGN KEY (`assessment_id`) REFERENCES `pcos_comprehensive_assessments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `pcos_lab_results`;

CREATE TABLE `pcos_lab_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `test_date` date NOT NULL,
  `test_type` enum('hormone_panel','thyroid_function','blood_glucose','insulin','lipid_profile','ultrasound','other') DEFAULT NULL,
  `test_name` varchar(255) DEFAULT NULL,
  `result_value` decimal(10,4) DEFAULT NULL,
  `result_unit` varchar(50) DEFAULT NULL,
  `reference_range` varchar(100) DEFAULT NULL,
  `interpretation` enum('normal','abnormal','borderline') DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_lab_results_patient_date` (`patient_id`,`test_date`),
  CONSTRAINT `pcos_lab_results_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `pcos_recommendations`;

CREATE TABLE `pcos_recommendations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assessment_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `recommendation_type` enum('immediate','lifestyle','medical','monitoring','followup') NOT NULL,
  `priority_level` enum('low','moderate','high','urgent') DEFAULT 'moderate',
  `recommendation_text` text NOT NULL,
  `category` varchar(100) DEFAULT NULL,
  `status` enum('pending','acknowledged','in_progress','completed','dismissed') DEFAULT 'pending',
  `target_date` date DEFAULT NULL,
  `completion_date` date DEFAULT NULL,
  `physician_approved` tinyint(1) DEFAULT 0,
  `patient_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `assessment_id` (`assessment_id`),
  KEY `patient_id` (`patient_id`),
  KEY `recommendation_type` (`recommendation_type`),
  KEY `priority_level` (`priority_level`),
  KEY `idx_recommendations_priority` (`priority_level`,`status`),
  CONSTRAINT `pcos_recommendations_ibfk_1` FOREIGN KEY (`assessment_id`) REFERENCES `pcos_comprehensive_assessments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pcos_recommendations_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `pcos_symptom_improvement`;

CREATE TABLE `pcos_symptom_improvement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `treatment_plan_id` int(11) DEFAULT NULL,
  `assessment_date` date NOT NULL,
  `menstrual_regularity_improvement` int(11) DEFAULT NULL CHECK (`menstrual_regularity_improvement` between 0 and 10),
  `acne_improvement` int(11) DEFAULT NULL CHECK (`acne_improvement` between 0 and 10),
  `hirsutism_improvement` int(11) DEFAULT NULL CHECK (`hirsutism_improvement` between 0 and 10),
  `weight_improvement` int(11) DEFAULT NULL CHECK (`weight_improvement` between 0 and 10),
  `energy_improvement` int(11) DEFAULT NULL CHECK (`energy_improvement` between 0 and 10),
  `mood_improvement` int(11) DEFAULT NULL CHECK (`mood_improvement` between 0 and 10),
  `overall_satisfaction` int(11) DEFAULT NULL CHECK (`overall_satisfaction` between 1 and 10),
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `treatment_plan_id` (`treatment_plan_id`),
  CONSTRAINT `pcos_symptom_improvement_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`),
  CONSTRAINT `pcos_symptom_improvement_ibfk_2` FOREIGN KEY (`treatment_plan_id`) REFERENCES `pcos_treatment_plans` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `pcos_symptom_tracking`;

CREATE TABLE `pcos_symptom_tracking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `tracking_date` date NOT NULL,
  `menstrual_cycle_day` int(11) DEFAULT NULL,
  `cycle_length` int(11) DEFAULT NULL,
  `flow_intensity` enum('none','light','moderate','heavy') DEFAULT NULL,
  `hirsutism_score` int(11) DEFAULT NULL,
  `acne_severity` enum('none','mild','moderate','severe') DEFAULT NULL,
  `weight` decimal(5,2) DEFAULT NULL,
  `mood_rating` int(11) DEFAULT NULL COMMENT '1-10 scale',
  `energy_level` int(11) DEFAULT NULL COMMENT '1-10 scale',
  `sleep_hours` decimal(3,1) DEFAULT NULL,
  `stress_level` int(11) DEFAULT NULL COMMENT '1-10 scale',
  `pain_level` int(11) DEFAULT NULL COMMENT '1-10 scale',
  `additional_symptoms` text DEFAULT NULL COMMENT 'JSON array',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `tracking_date` (`tracking_date`),
  KEY `idx_symptom_tracking_date` (`tracking_date`),
  KEY `idx_symptom_tracking_patient_date` (`patient_id`,`tracking_date`),
  CONSTRAINT `pcos_symptom_tracking_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `pcos_symptoms`;

CREATE TABLE `pcos_symptoms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `record_id` int(11) DEFAULT NULL,
  `irregular_cycles` enum('yes','no') DEFAULT 'no',
  `hirsutism` enum('yes','no') DEFAULT 'no',
  `acne` enum('yes','no') DEFAULT 'no',
  `hair_loss` enum('yes','no') DEFAULT 'no',
  `weight_issues` enum('yes','no') DEFAULT 'no',
  `skin_tags` enum('yes','no') DEFAULT 'no',
  `dark_skin_patches` enum('yes','no') DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `record_id` (`record_id`),
  CONSTRAINT `pcos_symptoms_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pcos_symptoms_ibfk_2` FOREIGN KEY (`record_id`) REFERENCES `follicle_records` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `pcos_treatment_plans`;

CREATE TABLE `pcos_treatment_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `plan_name` varchar(255) DEFAULT NULL,
  `plan_type` enum('lifestyle','medical','combined') DEFAULT NULL,
  `dietary_recommendations` text DEFAULT NULL,
  `exercise_recommendations` text DEFAULT NULL,
  `stress_management` text DEFAULT NULL,
  `sleep_recommendations` text DEFAULT NULL,
  `supplement_recommendations` text DEFAULT NULL,
  `medications` text DEFAULT NULL,
  `monitoring_plan` text DEFAULT NULL,
  `weight_goal` decimal(5,2) DEFAULT NULL,
  `cycle_regularity_goal` tinyint(1) DEFAULT NULL,
  `symptom_improvement_goals` text DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` enum('active','completed','paused','cancelled') DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_treatment_plans_patient_status` (`patient_id`,`status`),
  CONSTRAINT `pcos_treatment_plans_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `permissions`;

CREATE TABLE `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `permissions` VALUES("1","bypass_subscription","Allows user to bypass all subscription checks for development purposes.");
INSERT INTO `permissions` VALUES("2","compare_assessments","Allows user to use the assessment comparison feature.");
INSERT INTO `permissions` VALUES("3","view_premium_content","Allows user to access all subscription-locked content like resources and trackers.");



DROP TABLE IF EXISTS `resource_categories`;

CREATE TABLE `resource_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `resource_categories_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `role_permissions`;

CREATE TABLE `role_permissions` (
  `role_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`role_id`,`permission_id`),
  KEY `permission_id` (`permission_id`),
  CONSTRAINT `role_permissions_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_permissions_ibfk_2` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `role_permissions` VALUES("1","1");
INSERT INTO `role_permissions` VALUES("1","2");
INSERT INTO `role_permissions` VALUES("1","3");



DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `roles` VALUES("1","developer");



DROP TABLE IF EXISTS `scan_uploads`;

CREATE TABLE `scan_uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `appointment_id` int(11) DEFAULT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `upload_date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `scan_uploads_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `subscription_notifications`;

CREATE TABLE `subscription_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `notification_type` varchar(50) NOT NULL COMMENT 'e.g., 7_day_warning, 3_day_warning',
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `patient_notification_type` (`patient_id`,`notification_type`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `subscription_notifications_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `treatment_plans`;

CREATE TABLE `treatment_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `diagnosis` text DEFAULT NULL,
  `treatment_type` enum('medication','lifestyle','surgical','other') DEFAULT NULL,
  `pcos_phenotype` enum('classic','ovulatory','normoandrogenic','mild') DEFAULT NULL,
  `primary_symptoms` text DEFAULT NULL COMMENT 'JSON array of primary symptoms',
  `treatment_goals` text DEFAULT NULL COMMENT 'JSON array of goals',
  `contraindications` text DEFAULT NULL,
  `monitoring_parameters` text DEFAULT NULL COMMENT 'JSON array of parameters to monitor',
  `expected_outcomes` text DEFAULT NULL,
  `alternative_treatments` text DEFAULT NULL,
  `patient_preferences` text DEFAULT NULL,
  `cost_considerations` text DEFAULT NULL,
  `follow_up_schedule` text DEFAULT NULL COMMENT 'JSON array of follow-up dates',
  `medication_name` varchar(100) DEFAULT NULL,
  `dosage` varchar(50) DEFAULT NULL,
  `frequency` varchar(50) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `instructions` text DEFAULT NULL,
  `status` enum('active','completed','cancelled') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor_id` (`doctor_id`),
  CONSTRAINT `treatment_plans_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `treatment_plans_ibfk_2` FOREIGN KEY (`doctor_id`) REFERENCES `doctors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




DROP TABLE IF EXISTS `user_roles`;

CREATE TABLE `user_roles` (
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `user_roles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `user_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `user_roles` VALUES("12","1");



DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('patient','doctor','admin') NOT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `users` VALUES("1","admin","admin@fdms.com","$2y$10$YnKl4d9f4G87jHWv7sIu7Oyk3.6.lSToVTuZ/7XXpCx0kEmJ0Psyu","admin","active","2025-09-20 03:28:08","2025-09-20 03:32:10");
INSERT INTO `users` VALUES("2","dr_smith","dr.smith@fdms.com","$2y$10$cCbtsvi3oRhGQUJol1tDVOsJmCDwmdodLG36czo6Gp6TkRTftjb9u","doctor","active","2025-09-20 03:28:08","2025-09-20 03:32:10");
INSERT INTO `users` VALUES("12","Cynthia2","instructor11@mail.com","$2y$10$D04xmdDz42paaomDBLnWBOKqOiHBVNyGwPu1n1PwPUoa6NK6jkOqy","patient","active","2025-10-30 11:18:14","2025-10-30 11:18:14");
INSERT INTO `users` VALUES("16","ubong","ub@mail.com","$2y$10$mHWb/yJwpHS6d4mXU.u4a.p6eyceN67HE3y2UBQbmOENf13Y7f/52","patient","active","2025-11-04 19:37:29","2025-11-04 19:37:29");



