<?php
// We need to get the count of pending approvals.
// config.php is needed for the Database class and other helpers.
if (file_exists(__DIR__ . '/../../config.php')) {
    require_once __DIR__ . '/../../config.php';
}

$currentPage = getCurrentPage();

// This function returns 'active' if the current page is in the provided list.
function is_active($pages, $current) {
    return in_array($current, (array)$pages) ? 'active' : '';
}

// Fetch the count of pending doctor approvals
$pending_approvals_count = 0;
$db = new Database();
$conn = $db->getConnection();
$stmt = $conn->query("SELECT COUNT(*) FROM users WHERE status = 'pending_approval' AND role = 'doctor'");
$pending_approvals_count = $stmt->fetchColumn();
?>
<style>
    .sidebar {
        /* A subtle gradient for a more modern feel */
        background: linear-gradient(180deg, #ffffff 0%, #f8f9fa 100%);
        border-right: 1px solid #e9ecef;
    }

    .sidebar-header {
        /* Make the header more distinct */
        border-bottom: 1px solid #dee2e6;
    }

    .sidebar-header h6 {
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        color: #6c757d;
    }

    .sidebar .nav-link {
        font-weight: 500;
        color: #495057; /* Softer text color */
        transition: all 0.25s ease-in-out;
        border-radius: 0 30px 30px 0;
        margin: 0.1rem 1rem 0.1rem 0; /* Add vertical margin */
        padding: 0.85rem 1rem; /* Adjust padding for better balance */
        border-left: 4px solid transparent; /* Add a transparent border for alignment */
    }

    .sidebar .nav-link:hover {
        background-color: #e9d5ff; /* A slightly richer hover color */
        color: #764ba2;
        transform: translateX(5px); /* Add a subtle slide effect on hover */
    }

    .sidebar .nav-link.active {
        background-color: #764ba2;
        color: #fff;
        border-left-color: #5a3a7f; /* Add a darker left border for depth */
        box-shadow: 0 4px 12px rgba(118, 75, 162, 0.25); /* Add a shadow to the active item */
    }

    .sidebar .nav-link i {
        width: 25px; /* Increase icon width for better spacing */
        text-align: center;
        font-size: 1.1rem; /* Slightly larger icons */
    }

    /* Style for the notification badge */
    .sidebar .nav-link .badge {
        font-size: 0.75em;
        font-weight: 700;
        line-height: 1;
        padding: 0.35em 0.65em;
        border-radius: 50rem;
    }

    .sidebar .nav-link .ms-auto {
        transition: all 0.25s ease-in-out;
    }
</style>
<nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block sidebar collapse shadow-sm">
    <div class="position-sticky pt-3">
        <div class="sidebar-header px-3 pb-3">
            <h6 class="text-uppercase text-muted fw-bold small">Admin Navigation</h6>
        </div>
        
        <ul class="nav flex-column mt-3">
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('dashboard.php', $currentPage); ?>" href="dashboard.php">
                    <i class="fas fa-tachometer-alt me-3"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active(['users.php', 'manage_roles.php'], $currentPage); ?>" href="users.php">
                    <i class="fas fa-users-cog me-3"></i>
                    <span>User Management</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex justify-content-between align-items-center <?php echo is_active('pending_approvals.php', $currentPage); ?>" href="pending_approvals.php">
                    <div><i class="fas fa-user-clock me-3"></i><span>Pending Approvals</span></div>
                    <?php if ($pending_approvals_count > 0): ?>
                        <span id="pending-approvals-badge" class="badge bg-danger rounded-pill ms-auto"><?php echo $pending_approvals_count; ?></span>
                    <?php else: ?>
                        <span id="pending-approvals-badge" class="badge bg-danger rounded-pill ms-auto" style="display: none;">0</span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active(['doctors.php', 'patients.php', 'records.php'], $currentPage); ?>" href="patients.php">
                    <i class="fas fa-user-injured me-3"></i>
                    <span>Patient Data</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('subscription_report.php', $currentPage); ?>" href="subscription_report.php">
                    <i class="fas fa-chart-bar me-3"></i>
                    <span>Reports</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active(['logs.php', 'backup.php'], $currentPage); ?>" href="logs.php">
                    <i class="fas fa-cogs me-3"></i>
                    <span>System</span>
                </a>
            </li>
        </ul>
    </div>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const badge = document.getElementById('pending-approvals-badge');

    function fetchPendingCount() {
        fetch('includes/get_pending_count.php')
            .then(response => response.json())
            .then(data => {
                if (data.count > 0) {
                    badge.textContent = data.count;
                    badge.style.display = 'inline-block';
                } else {
                    badge.style.display = 'none';
                }
            })
            .catch(error => console.error('Error fetching pending count:', error));
    }

    // Fetch the count every 30 seconds
    setInterval(fetchPendingCount, 30000);
});
</script>