<?php
// This script is designed to be run by a cron job or an external web cron service.

// Increase execution time and memory limit for large databases
@set_time_limit(300);
@ini_set('memory_limit', '256M');

require_once '../config.php';

function perform_database_backup() {
    $backup_dir = __DIR__ . '/../backups/';
    $filename = "fdms-backup-" . date("Y-m-d") . ".sql";
    $filepath = $backup_dir . $filename;

    // Check if a backup for today already exists
    if (file_exists($filepath)) {
        return "Backup for today already exists.";
    }

    try {
        $db = new Database();
        $conn = $db->getConnection();
        
        $tables = array();
        $result = $conn->query("SHOW TABLES");
        while($row = $result->fetch(PDO::FETCH_NUM)){
            $tables[] = $row[0];
        }
        
        $sql_dump = "";
        
        foreach($tables as $table){
            $result = $conn->query("SELECT * FROM $table");
            $num_fields = $result->columnCount();
            
            $sql_dump .= "DROP TABLE IF EXISTS `$table`;";
            
            $create_table_stmt = $conn->query("SHOW CREATE TABLE `$table`");
            $create_table_row = $create_table_stmt->fetch(PDO::FETCH_NUM);
            $sql_dump .= "\n\n".$create_table_row[1].";\n\n";
            
            while($row = $result->fetch(PDO::FETCH_NUM)){
                $sql_dump .= "INSERT INTO `$table` VALUES(";
                for ($j = 0; $j < $num_fields; $j++) {
                    if ($row[$j] === null) {
                        $sql_dump .= 'NULL';
                    } else {
                        $value = addslashes((string)$row[$j]);
                        $value = preg_replace("/\n/", "\\n", $value);
                        $sql_dump .= '"' . $value . '"';
                    }
                    if ($j < ($num_fields - 1)) $sql_dump .= ',';
                }
                $sql_dump .= ");\n";
            }
            $sql_dump.="\n\n\n";
        }

        // Save the file
        file_put_contents($filepath, $sql_dump);
        logActivity(null, 'Automated Backup Success', "Backup file created: $filename");
        return "Successfully created backup: $filename";

    } catch (Exception $e) {
        logActivity(null, 'Automated Backup Failed', $e->getMessage());
        return "Error creating backup: " . $e->getMessage();
    }
}

function prune_old_backups($days_to_keep = 30) {
    $backup_dir = __DIR__ . '/../backups/';
    $files = glob($backup_dir . "*.sql");
    $pruned_count = 0;

    foreach ($files as $file) {
        if (filemtime($file) < time() - ($days_to_keep * 86400)) {
            if (unlink($file)) {
                $pruned_count++;
            }
        }
    }
    if ($pruned_count > 0) {
        logActivity(null, 'Automated Backup Pruning', "Deleted {$pruned_count} old backup files.");
        return "Pruned {$pruned_count} old backups.";
    }
    return "No old backups to prune.";
}

// Execute the functions
echo perform_database_backup() . "<br>";
echo prune_old_backups();

?>
