<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('Invalid record ID.');
}

$record_id = (int)$_GET['id'];

// Fetch follicle record
$stmt = $conn->prepare("SELECT * FROM follicle_records WHERE id = ?");
$stmt->execute([$record_id]);
$record = $stmt->fetch();

if (!$record) {
    die('Record not found.');
}

// Fetch PCOS symptoms
$sym_stmt = $conn->prepare("SELECT * FROM pcos_symptoms WHERE record_id = ?");
$sym_stmt->execute([$record_id]);
$symptoms = $sym_stmt->fetch();

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Collect and sanitize form data
    $diagnosis = sanitize($_POST['diagnosis']);
    $treatment_plan = sanitize($_POST['treatment_plan']);
    $notes = sanitize($_POST['notes']);

    // PCOS symptoms
    $irregular_cycles = sanitize($_POST['irregular_cycles']);
    $hirsutism = sanitize($_POST['hirsutism']);
    $acne = sanitize($_POST['acne']);
    $hair_loss = sanitize($_POST['hair_loss']);
    $weight_issues = sanitize($_POST['weight_issues']);
    $skin_tags = sanitize($_POST['skin_tags']);
    $dark_skin_patches = sanitize($_POST['dark_skin_patches']);

    try {
        $conn->beginTransaction();

        // Update follicle record
        $stmt = $conn->prepare("
            UPDATE follicle_records
            SET diagnosis = ?, treatment_plan = ?, notes = ?
            WHERE id = ?
        ");
        $stmt->execute([
            $diagnosis, $treatment_plan, $notes, $record_id
        ]);

        // Update PCOS symptoms
        if ($symptoms) {
            $sym_stmt = $conn->prepare("
                UPDATE pcos_symptoms
                SET irregular_cycles = ?, hirsutism = ?, acne = ?, hair_loss = ?, weight_issues = ?, skin_tags = ?, dark_skin_patches = ?
                WHERE record_id = ?
            ");
            $sym_stmt->execute([
                $irregular_cycles, $hirsutism, $acne, $hair_loss, $weight_issues, $skin_tags, $dark_skin_patches, $record_id
            ]);
        }

        $conn->commit();
        $success = 'Record updated successfully!';
        logActivity($_SESSION['user_id'], 'Edited follicle record', "Record ID: $record_id");
        // Refresh data
        header("Location: view_record.php?id=$record_id");
        exit;
    } catch (Exception $e) {
        $conn->rollBack();
        $error = 'Failed to update record: ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Record - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="pt-3 pb-2 mb-3 border-bottom">
                    <h2>Edit Follicle Record</h2>
                    <a href="view_record.php?id=<?php echo $record_id; ?>" class="btn btn-secondary btn-sm mb-3">
                        <i class="fas fa-arrow-left"></i> Back to Details
                    </a>
                </div>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                <form method="post" class="card p-4">
                    <div class="mb-3">
                        <label for="diagnosis" class="form-label">Diagnosis</label>
                        <input type="text" class="form-control" id="diagnosis" name="diagnosis" value="<?php echo htmlspecialchars($record['diagnosis']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="treatment_plan" class="form-label">Treatment Plan</label>
                        <input type="text" class="form-control" id="treatment_plan" name="treatment_plan" value="<?php echo htmlspecialchars($record['treatment_plan']); ?>">
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">Notes</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"><?php echo htmlspecialchars($record['notes']); ?></textarea>
                    </div>
                    <hr>
                    <h5>PCOS Symptoms</h5>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="irregular_cycles" class="form-label">Irregular Cycles</label>
                            <input type="text" class="form-control" id="irregular_cycles" name="irregular_cycles" value="<?php echo htmlspecialchars($symptoms['irregular_cycles'] ?? ''); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="hirsutism" class="form-label">Hirsutism</label>
                            <input type="text" class="form-control" id="hirsutism" name="hirsutism" value="<?php echo htmlspecialchars($symptoms['hirsutism'] ?? ''); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="acne" class="form-label">Acne</label>
                            <input type="text" class="form-control" id="acne" name="acne" value="<?php echo htmlspecialchars($symptoms['acne'] ?? ''); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="hair_loss" class="form-label">Hair Loss</label>
                            <input type="text" class="form-control" id="hair_loss" name="hair_loss" value="<?php echo htmlspecialchars($symptoms['hair_loss'] ?? ''); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="weight_issues" class="form-label">Weight Issues</label>
                            <input type="text" class="form-control" id="weight_issues" name="weight_issues" value="<?php echo htmlspecialchars($symptoms['weight_issues'] ?? ''); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="skin_tags" class="form-label">Skin Tags</label>
                            <input type="text" class="form-control" id="skin_tags" name="skin_tags" value="<?php echo htmlspecialchars($symptoms['skin_tags'] ?? ''); ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="dark_skin_patches" class="form-label">Dark Skin Patches</label>
                            <input type="text" class="form-control" id="dark_skin_patches" name="dark_skin_patches" value="<?php echo htmlspecialchars($symptoms['dark_skin_patches'] ?? ''); ?>">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-success">Update Record</button>
                </form>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>