<?php
// get_assessment_details.php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

$assessment_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$assessment_id) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'Invalid assessment ID']);
    exit();
}

// Fetch assessment details
$stmt = $conn->prepare("
    SELECT pca.*, p.name as patient_name, p.age 
    FROM pcos_comprehensive_assessments pca 
    JOIN patients p ON pca.patient_id = p.id 
    WHERE pca.id = ?
");
$stmt->execute([$assessment_id]);
$assessment = $stmt->fetch();

if (!$assessment) {
    header('HTTP/1.1 404 Not Found');
    echo json_encode(['error' => 'Assessment not found']);
    exit();
}

// Fetch recommendations
$stmt = $conn->prepare("SELECT * FROM pcos_recommendations WHERE assessment_id = ?");
$stmt->execute([$assessment_id]);
$recommendations = $stmt->fetchAll();

// Generate HTML for assessment details
$html = '
<div class="assessment-summary">
    <h6>Patient: ' . htmlspecialchars($assessment['patient_name']) . ' (Age: ' . $assessment['age'] . ')</h6>
    <div class="row">
        <div class="col-6">
            <strong>PCOS Probability:</strong> 
            <span class="badge bg-' . ($assessment['pcos_probability'] >= 70 ? 'danger' : ($assessment['pcos_probability'] >= 40 ? 'warning' : 'success')) . '">
                ' . $assessment['pcos_probability'] . '%
            </span>
        </div>
        <div class="col-6">
            <strong>Risk Level:</strong> 
            <span class="badge bg-' . ($assessment['risk_level'] == 'High' ? 'danger' : ($assessment['risk_level'] == 'Moderate-High' ? 'warning' : 'info')) . '">
                ' . $assessment['risk_level'] . '
            </span>
        </div>
    </div>
    <div class="row mt-2">
        <div class="col-6">
            <strong>BMI:</strong> ' . $assessment['bmi'] . '
        </div>
        <div class="col-6">
            <strong>Hirsutism Score:</strong> ' . $assessment['hirsutism_score'] . '
        </div>
    </div>
    <div class="mt-2">
        <strong>Diagnosis:</strong> ' . htmlspecialchars($assessment['diagnosis_category']) . '
    </div>
</div>';

// Generate HTML for recommendations
$rec_html = '';
if (!empty($recommendations)) {
    $rec_html = '<div class="recommendations-list">';
    foreach ($recommendations as $rec) {
        $rec_html .= '
        <div class="form-check">
            <input class="form-check-input" type="checkbox" name="approved_recommendations[]" value="' . $rec['id'] . '" id="rec_' . $rec['id'] . '">
            <label class="form-check-label" for="rec_' . $rec['id'] . '">
                ' . htmlspecialchars($rec['description']) . '
                <small class="text-muted">(' . ucfirst($rec['priority_level']) . ' priority)</small>
            </label>
        </div>';
    }
    $rec_html .= '</div>';
} else {
    $rec_html = '<p class="text-muted">No recommendations generated for this assessment.</p>';
}

header('Content-Type: application/json');
echo json_encode([
    'html' => $html,
    'recommendations' => $rec_html
]);
?>