<?php
require_once '../config.php';
requireRole('doctor');

header('Content-Type: application/json');

$patient_id = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;

if (!$patient_id) {
    http_response_code(400);
    echo json_encode(['content' => 'Invalid Patient ID.']);
    exit();
}

$db = new Database();
$conn = $db->getConnection();

// Fetch last 14 days of symptom tracking data
$stmt = $conn->prepare("
    SELECT 
        AVG(mood_rating) as avg_mood,
        AVG(stress_level) as avg_stress,
        AVG(energy_level) as avg_energy,
        AVG(pain_level) as avg_pain,
        COUNT(*) as entry_count
    FROM pcos_symptom_tracking
    WHERE patient_id = ? AND tracking_date >= DATE_SUB(CURDATE(), INTERVAL 14 DAY)
");
$stmt->execute([$patient_id]);
$trends = $stmt->fetch();

if (!$trends || $trends['entry_count'] == 0) {
    echo json_encode(['content' => '<div class="text-muted small p-2">No recent symptom data tracked by this patient.</div>']);
    exit();
}

function getTrendIndicator($value) {
    if ($value >= 7) return '<span class="text-success">Good</span>';
    if ($value >= 4) return '<span class="text-warning">Moderate</span>';
    return '<span class="text-danger">Poor</span>';
}

$content = '<ul class="list-unstyled mb-0 small">';
$content .= '<li class="d-flex justify-content-between"><span>Avg. Mood:</span> <strong>' . ($trends['avg_mood'] ? round($trends['avg_mood'], 1) : 'N/A') . '/10</strong></li>';
$content .= '<li class="d-flex justify-content-between"><span>Avg. Energy:</span> <strong>' . ($trends['avg_energy'] ? round($trends['avg_energy'], 1) : 'N/A') . '/10</strong></li>';
$content .= '<li class="d-flex justify-content-between"><span>Avg. Stress:</span> <strong>' . ($trends['avg_stress'] ? round($trends['avg_stress'], 1) : 'N/A') . '/10</strong></li>';
$content .= '<li class="d-flex justify-content-between"><span>Avg. Pain:</span> <strong>' . ($trends['avg_pain'] ? round($trends['avg_pain'], 1) : 'N/A') . '/10</strong></li>';
$content .= '<hr class="my-1">';
$content .= '<li class="text-muted"><small>Based on ' . $trends['entry_count'] . ' entries in the last 14 days.</small></li>';
$content .= '</ul>';

echo json_encode(['content' => $content]);
?>