<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

if (isset($_GET['id'])) {
    $resource_id = (int)$_GET['id'];
    
    // Get doctor info to ensure they can only access their own resources
    $stmt = $conn->prepare("SELECT id FROM doctors WHERE user_id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $doctor = $stmt->fetch();
    
    // Get resource data
    $stmt = $conn->prepare("
        SELECT * FROM pcos_education_resources 
        WHERE id = ? AND created_by = ?
    ");
    $stmt->execute([$resource_id, $doctor['id']]);
    $resource = $stmt->fetch();
    
    if ($resource) {
        header('Content-Type: application/json');
        echo json_encode($resource);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Resource not found']);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Resource ID required']);
}
?>