<?php
$currentPage = getCurrentPage();

// Simplified function to only return the 'active' class if the page matches.
function is_active($pages, $current) {
    return in_array($current, (array)$pages) ? 'active' : '';
}
?>
<style>
    .sidebar {
        /* A subtle gradient for a more modern feel */
        background: linear-gradient(180deg, #ffffff 0%, #f8f9fa 100%);
        border-right: 1px solid #e9ecef;
    }

    .sidebar-header {
        /* Make the header more distinct */
        border-bottom: 1px solid #dee2e6;
    }

    .sidebar-header h6 {
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        color: #6c757d;
    }

    .sidebar .nav-link {
        font-weight: 500;
        color: #495057; /* Slightly softer text color */
        transition: all 0.25s ease-in-out;
        border-radius: 0 30px 30px 0;
        margin: 0.1rem 1rem 0.1rem 0; /* Add vertical margin */
        padding: 0.85rem 1rem; /* Adjust padding for better balance */
        border-left: 4px solid transparent; /* Add a transparent border for alignment */
    }

    .sidebar .nav-link:hover {
        background-color: #e9d5ff; /* A slightly richer hover color */
        color: #764ba2;
        transform: translateX(5px); /* Add a subtle slide effect on hover */
    }

    .sidebar .nav-link.active {
        background-color: #764ba2;
        color: #fff;
        border-left-color: #5a3a7f; /* Add a darker left border for depth */
        box-shadow: 0 4px 12px rgba(118, 75, 162, 0.25); /* Add a shadow to the active item */
    }

    .sidebar .nav-link i {
        width: 25px; /* Increase icon width for better spacing */
        text-align: center;
        font-size: 1.1rem; /* Slightly larger icons */
    }
</style>
<nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block sidebar collapse shadow-sm">
    <div class="position-sticky pt-3">
        <div class="sidebar-header px-3 pb-3">
            <h6 class="text-uppercase text-muted fw-bold small">Doctor Navigation</h6>
        </div>
        
        <ul class="nav flex-column mt-3">
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('dashboard.php', $currentPage); ?>" href="dashboard.php">
                    <i class="fas fa-tachometer-alt me-3"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('pcos_analysis.php', $currentPage); ?>" href="pcos_analysis.php">
                    <i class="fas fa-chart-pie me-3"></i>
                    <span>PCOS Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active(['patients.php', 'add_patient.php', 'patient_profile.php'], $currentPage); ?>" href="patients.php">
                    <i class="fas fa-user-injured me-3"></i>
                    <span>My Patients</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active(['appointments.php', 'schedule_appointment.php'], $currentPage); ?>" href="appointments.php">
                    <i class="fas fa-calendar-check me-3"></i>
                    <span>Appointments</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active(['records.php', 'add_record.php', 'view_record.php', 'edit_record.php'], $currentPage); ?>" href="records.php">
                    <i class="fas fa-file-medical me-3"></i>
                    <span>Medical Records</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active(['treatment_plans.php', 'view_treatment.php', 'edit_treatment.php'], $currentPage); ?>" href="treatment_plans.php">
                    <i class="fas fa-clipboard-list me-3"></i>
                    <span>Treatment Plans</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('pcos_analytics.php', $currentPage); ?>" href="pcos_analytics.php">
                    <i class="fas fa-chart-line me-3"></i>
                    <span>Analytics</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('pcos_education_resources.php', $currentPage); ?>" href="pcos_education_resources.php">
                    <i class="fas fa-book-medical me-3"></i>
                    <span>Resources</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('treatment_guidelines.php', $currentPage); ?>" href="treatment_guidelines.php">
                    <i class="fas fa-file-prescription me-3"></i>
                    <span>Guidelines</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link d-flex align-items-center <?php echo is_active('profile.php', $currentPage); ?>" href="profile.php">
                    <i class="fas fa-user-cog me-3"></i>
                    <span>My Profile</span>
                </a>
            </li>
        </ul>
    </div>
</nav>