<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

// Fetch all follicle records with patient and doctor info
$stmt = $conn->prepare("
    SELECT fr.*, p.name AS patient_name, p.age AS patient_age, d.name AS doctor_name
    FROM follicle_records fr
    JOIN patients p ON fr.patient_id = p.id
    JOIN doctors d ON fr.doctor_id = d.id
    ORDER BY fr.examination_date DESC
");
$stmt->execute();
$records = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Follicle Records - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Follicle Diagnostic Records</h1>
                    <a href="add_record.php" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Add New Record
                    </a>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">All Records</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Patient</th>
                                    <th>Age</th>
                                    <th>Doctor</th>
                                    <th>Date</th>
                                    <th>PCOS Score</th>
                                    <th>PCOS Risk</th>
                                    <th>Diagnosis</th>
                                    <th>Treatment Plan</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($records): ?>
                                    <?php foreach ($records as $i => $rec): ?>
                                        <tr>
                                            <td><?php echo $i + 1; ?></td>
                                            <td><?php echo htmlspecialchars($rec['patient_name']); ?></td>
                                            <td><?php echo htmlspecialchars($rec['patient_age']); ?></td>
                                            <td><?php echo htmlspecialchars($rec['doctor_name']); ?></td>
                                            <td><?php echo htmlspecialchars($rec['examination_date']); ?></td>
                                            <td><?php echo htmlspecialchars($rec['pcos_score']); ?></td>
                                            <td><?php echo htmlspecialchars($rec['pcos_risk_level']); ?></td>
                                            <td><?php echo htmlspecialchars($rec['diagnosis']); ?></td>
                                            <td><?php echo htmlspecialchars($rec['treatment_plan']); ?></td>
                                            <td>
                                                <a href="view_record.php?id=<?php echo $rec['id']; ?>" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="edit_record.php?id=<?php echo $rec['id']; ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="10" class="text-center">No records found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>