<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

// Handle report submission
$success = '';
$error = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['submit_report'])) {
    $patient_id = (int)$_POST['patient_id'];
    $report_title = sanitize($_POST['report_title']);
    $report_content = sanitize($_POST['report_content']);

    if (!$patient_id || empty($report_title) || empty($report_content)) {
        $error = "Please fill in all fields.";
    } else {
        try {
            $stmt = $conn->prepare("INSERT INTO patient_reports (patient_id, doctor_id, report_title, report_content, created_at) VALUES (?, ?, ?, ?, NOW())");
            $stmt->execute([$patient_id, $_SESSION['doctor_id'], $report_title, $report_content]);
            $success = "Report saved successfully.";
        } catch (Exception $e) {
            $error = "Failed to save report: " . $e->getMessage();
        }
    }
}

// Fetch all patients for dropdown
$stmt = $conn->query("SELECT id, name FROM patients ORDER BY name ASC");
$patients = $stmt->fetchAll();

// Fetch all reports
$stmt = $conn->prepare("
    SELECT pr.*, p.name AS patient_name, d.name AS doctor_name
    FROM patient_reports pr
    JOIN patients p ON pr.patient_id = p.id
    JOIN doctors d ON pr.doctor_id = d.id
    ORDER BY pr.created_at DESC
");
$stmt->execute();
$reports = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Doctor Reports - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?> 
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?> 
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="pt-3 pb-2 mb-3 border-bottom">
                    <h2>
                        <i class="fas fa-file-medical text-primary me-2"></i>
                        Doctor Reports
                    </h2>
                </div>
                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <!-- Report Submission Form -->
                <div class="card mb-4">
                    <div class="card-header">
                        <strong>Add New Report</strong>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label for="patient_id" class="form-label">Patient</label>
                                <select class="form-select" id="patient_id" name="patient_id" required>
                                    <option value="">Select Patient</option>
                                    <?php foreach ($patients as $patient): ?>
                                        <option value="<?php echo $patient['id']; ?>">
                                            <?php echo htmlspecialchars($patient['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="report_title" class="form-label">Report Title</label>
                                <input type="text" class="form-control" id="report_title" name="report_title" required>
                            </div>
                            <div class="mb-3">
                                <label for="report_content" class="form-label">Report Content</label>
                                <textarea class="form-control" id="report_content" name="report_content" rows="4" required></textarea>
                            </div>
                            <button type="submit" name="submit_report" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Save Report
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Reports Table -->
                <div class="card">
                    <div class="card-header">
                        <strong>All Reports</strong>
                    </div>
                    <div class="card-body table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Patient</th>
                                    <th>Doctor</th>
                                    <th>Title</th>
                                    <th>Date</th>
                                    <th>Content</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($reports): ?>
                                    <?php foreach ($reports as $i => $report): ?>
                                        <tr>
                                            <td><?php echo $i + 1; ?></td>
                                            <td><?php echo htmlspecialchars($report['patient_name'] ?? ''); ?></td>
                                            <td><?php echo htmlspecialchars($report['doctor_name'] ?? ''); ?></td>
                                            <td><?php echo htmlspecialchars($report['report_title'] ?? ''); ?></td>
                                            <td><?php echo date('M j, Y', strtotime($report['created_at'])); ?></td>
                                            <td><?php echo nl2br(htmlspecialchars($report['report_content'] ?? '')); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No reports found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>