<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

// Fetch all reviewed PCOS assessments
$stmt = $conn->prepare("
    SELECT 
        pca.*,
        p.name AS patient_name,
        p.age,
        p.contact
    FROM pcos_comprehensive_assessments pca
    JOIN patients p ON pca.patient_id = p.id
    WHERE pca.physician_reviewed = 1
    ORDER BY pca.created_at DESC
");
$stmt->execute();
$cases = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Reviewed PCOS Cases - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?> 
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?> 
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="fas fa-clipboard-check text-success me-2"></i>
                        Reviewed PCOS Cases
                    </h1>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">All Reviewed Assessments</h5>
                    </div>
                    <div class="card-body table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Patient</th>
                                    <th>Age</th>
                                    <th>Contact</th>
                                    <th>Doctor</th>
                                    <th>Assessment Date</th>
                                    <th>Reviewed At</th>
                                    <th>PCOS Probability</th>
                                    <th>Risk Level</th>
                                    <th>Diagnosis</th>
                                    <th>Physician Notes</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($cases): ?>
                                    <?php foreach ($cases as $i => $case): ?>
                                        <tr>
                                            <td><?php echo $i + 1; ?></td>
                                            <td><?php echo htmlspecialchars($case['patient_name'] ?? ''); ?></td>
                                            <td><?php echo htmlspecialchars($case['age'] ?? ''); ?></td>
                                            <td><?php echo htmlspecialchars($case['contact'] ?? ''); ?></td>
                                            <td>-</td> <!-- Doctor info not available -->
                                            <td><?php echo htmlspecialchars($case['assessment_date'] ?? ''); ?></td>
                                            <td>-</td> <!-- Reviewed At not available -->
                                            <td>
                                                <span class="badge bg-<?php 
                                                    echo ($case['pcos_probability'] ?? 0) >= 70 ? 'danger' : 
                                                        (($case['pcos_probability'] ?? 0) >= 40 ? 'warning' : 'success');
                                                ?>">
                                                    <?php echo $case['pcos_probability'] ?? 'N/A'; ?>%
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?php 
                                                    echo ($case['risk_level'] ?? '') == 'High' ? 'danger' : 
                                                        (($case['risk_level'] ?? '') == 'Moderate-High' ? 'warning' : 
                                                        (($case['risk_level'] ?? '') == 'Moderate' ? 'info' : 'secondary'));
                                                ?>">
                                                    <?php echo htmlspecialchars($case['risk_level'] ?? ''); ?>
                                                </span>
                                            </td>
                                            <td><?php echo htmlspecialchars($case['diagnosis_category'] ?? ''); ?></td>
                                            <td><?php echo nl2br(htmlspecialchars($case['physician_notes'] ?? '')); ?></td>
                                            <td>
                                                <a href="view_comprehensive_assessment.php?id=<?php echo $case['id']; ?>" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> View
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="12" class="text-center">No reviewed cases found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>