<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

// Fetch all guideline categories and items
$stmt_cats = $conn->query("SELECT * FROM guideline_categories ORDER BY display_order ASC");
$categories = $stmt_cats->fetchAll();

$stmt_items = $conn->query("SELECT * FROM guideline_items ORDER BY category_key, display_order ASC");
$items_raw = $stmt_items->fetchAll();

$guidelines = [];
foreach ($items_raw as $item) {
    $guidelines[$item['category_key']][$item['subcategory']][] = $item;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PCOS Treatment Guidelines - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .guideline-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
        }
        .nav-tabs .nav-link {
            color: #495057;
            font-weight: 500;
        }
        .nav-tabs .nav-link.active {
            color: #667eea;
            border-color: #dee2e6 #dee2e6 #fff;
            border-bottom: 3px solid #667eea;
        }
        .guideline-card {
            border-left: 4px solid #667eea;
            margin-bottom: 1.5rem;
        }
        .guideline-card h6 {
            color: #667eea;
        }
        .list-group-item {
            border: none;
            padding-left: 0;
        }
        .list-group-item i {
            color: #28a745;
        }
        mark {
            background-color: #ffc107;
        }
        @media print {
            body {
                background-color: white !important;
            }
            .sidebar, .navbar, .guideline-header .text-end, #guidelineSearch, #printButton, .input-group-text {
                display: none !important;
            }
            main {
                width: 100% !important;
                margin: 0 !important;
                padding: 0 !important;
            }
            .guideline-header {
                background: none !important;
                color: black !important;
                padding: 0 !important;
                margin-bottom: 1rem !important;
                border-bottom: 2px solid #dee2e6;
            }
            .nav-tabs, .tab-pane {
                display: block !important;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="guideline-header mt-4">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h2><i class="fas fa-book-medical me-2"></i>PCOS Treatment & Management Guidelines</h2>
                            <p class="mb-0">A summary of evidence-based clinical guidelines for managing PCOS.</p>
                        </div>
                        <div class="col-md-4 text-end d-none d-md-block">
                            <i class="fas fa-file-prescription fa-4x opacity-75"></i>
                        </div>
                    </div>
                </div>

                <!-- Search Bar -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div class="input-group input-group-lg flex-grow-1 me-3">
                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                        <input type="text" id="guidelineSearch" class="form-control" placeholder="Search guidelines (e.g., 'Metformin', 'Letrozole', 'Hirsutism')...">
                    </div>
                    <div>
                        <button class="btn btn-outline-secondary" id="printButton">
                            <i class="fas fa-print me-2"></i>Print Guidelines
                        </button>
                    </div>
                </div>

                <ul class="nav nav-tabs mb-4" id="guidelineTabs" role="tablist">
                    <?php foreach ($categories as $index => $cat): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link <?php echo $index === 0 ? 'active' : ''; ?>" id="<?php echo $cat['category_key']; ?>-tab" data-bs-toggle="tab" data-bs-target="#<?php echo $cat['category_key']; ?>" type="button" role="tab">
                            <i class="fas <?php echo $cat['icon']; ?> me-2"></i><?php echo htmlspecialchars($cat['title']); ?>
                        </button>
                    </li>
                    <?php endforeach; ?>
                </ul>

                <div class="tab-content" id="guidelineTabsContent">
                    <?php foreach ($categories as $index => $cat): ?>
                    <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>" id="<?php echo $cat['category_key']; ?>" role="tabpanel">
                        <div class="row">
                            <?php if (isset($guidelines[$cat['category_key']])): ?>
                                <?php foreach ($guidelines[$cat['category_key']] as $subcategory => $items): ?>
                                <div class="col-md-6">
                                    <div class="card guideline-card">
                                        <div class="card-body">
                                            <h6><i class="fas fa-check-circle me-2"></i><?php echo ucwords(str_replace('_', ' ', $subcategory)); ?></h6>
                                            <ul class="list-group list-group-flush">
                                                <?php foreach ($items as $item): ?>
                                                <li class="list-group-item">
                                                    <i class="fas fa-check me-2"></i><?php echo $item['content']; ?>
                                                </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p class="text-muted">No guidelines available for this category yet.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

            </main>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('printButton').addEventListener('click', function() {
            // Temporarily show all tabs and content for printing
            document.querySelectorAll('.nav-tabs .nav-link, .tab-content .tab-pane').forEach(el => el.classList.add('show', 'active'));
            window.print();
        });
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('guidelineSearch');
            if (searchInput) {
                // Store original HTML of each item to revert highlights
                const originalItems = new Map();
                document.querySelectorAll('.list-group-item').forEach(item => {
                    originalItems.set(item, item.innerHTML);
                });

                searchInput.addEventListener('input', function() {
                    const searchTerm = this.value.toLowerCase().trim();
                    const tabs = document.querySelectorAll('.nav-tabs .nav-link');
                    const tabPanes = document.querySelectorAll('.tab-content .tab-pane');
                    let firstVisibleTab = null;

                    // If search is empty, restore everything and exit
                    if (!searchTerm) {
                        originalItems.forEach((html, item) => {
                            item.innerHTML = html;
                            item.style.display = 'list-item';
                        });
                        document.querySelectorAll('.guideline-card').forEach(card => card.style.display = 'block');
                        tabs.forEach(tab => tab.parentElement.style.display = 'list-item');
                        new bootstrap.Tab(tabs[0]).show();
                        return;
                    }

                    const searchRegex = new RegExp(searchTerm.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'gi');

                    tabPanes.forEach((pane, index) => {
                        const subcategoryCards = pane.querySelectorAll('.guideline-card');
                        let paneHasVisibleContent = false;

                        subcategoryCards.forEach(card => {
                            const items = card.querySelectorAll('.list-group-item');
                            let cardHasVisibleItems = false;

                            items.forEach(item => {
                                const originalHtml = originalItems.get(item);
                                const originalText = item.textContent; // Use textContent for matching to ignore HTML

                                if (originalText.toLowerCase().includes(searchTerm)) {
                                    item.innerHTML = originalHtml.replace(searchRegex, match => `<mark>${match}</mark>`);
                                    item.style.display = 'list-item';
                                    cardHasVisibleItems = true;
                                    paneHasVisibleContent = true;
                                } else {
                                    item.innerHTML = originalHtml; // Restore original content
                                    item.style.display = 'none';
                                }
                            });

                            card.style.display = cardHasVisibleItems ? 'block' : 'none';
                        });

                        const tabButton = tabs[index];
                        tabButton.parentElement.style.display = paneHasVisibleContent ? 'list-item' : 'none';
                        if (paneHasVisibleContent && !firstVisibleTab) {
                            firstVisibleTab = tabButton;
                        }
                    });

                    // If a search term is entered, activate the first tab that has visible content
                    if (searchTerm && firstVisibleTab) {
                        const activeTab = document.querySelector('.nav-tabs .nav-link.active');
                        if (activeTab !== firstVisibleTab) {
                            new bootstrap.Tab(firstVisibleTab).show();
                        }
                    }
                });
            }
        });
    </script>
</body>
</html>