<?php
require_once '../config.php';
requireRole('doctor');

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);

if (isset($input['order']) && is_array($input['order'])) {
    $ordered_ids = $input['order'];

    $db = new Database();
    $conn = $db->getConnection();

    try {
        $conn->beginTransaction();
        $stmt = $conn->prepare("UPDATE pcos_education_resources SET display_order = ? WHERE id = ?");

        foreach ($ordered_ids as $index => $id) {
            $stmt->execute([$index, (int)$id]);
        }

        $conn->commit();
        echo json_encode(['success' => true]);
    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid data received.']);
}