<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('Invalid record ID.');
}

$record_id = (int)$_GET['id'];

// Fetch follicle record with patient and doctor info
$stmt = $conn->prepare("
    SELECT fr.*, p.name AS patient_name, p.age AS patient_age, d.name AS doctor_name
    FROM follicle_records fr
    JOIN patients p ON fr.patient_id = p.id
    JOIN doctors d ON fr.doctor_id = d.id
    WHERE fr.id = ?
    LIMIT 1
");
$stmt->execute([$record_id]);
$record = $stmt->fetch();

if (!$record) {
    die('Record not found.');
}

// Fetch PCOS symptoms if available
$symptoms = [];
$sym_stmt = $conn->prepare("SELECT * FROM pcos_symptoms WHERE record_id = ?");
$sym_stmt->execute([$record_id]);
$symptoms = $sym_stmt->fetch();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>View Record - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="pt-3 pb-2 mb-3 border-bottom">
                    <h2>Follicle Record Details</h2>
                    <a href="records.php" class="btn btn-secondary btn-sm mb-3">
                        <i class="fas fa-arrow-left"></i> Back to Records
                    </a>
                </div>
                <div class="card mb-4">
                    <div class="card-header">
                        <strong>Patient:</strong> <?php echo htmlspecialchars($record['patient_name']); ?> (Age: <?php echo htmlspecialchars($record['patient_age']); ?>)
                    </div>
                    <div class="card-body">
                        <p><strong>Doctor:</strong> <?php echo htmlspecialchars($record['doctor_name']); ?></p>
                        <p><strong>Date:</strong> <?php echo htmlspecialchars($record['examination_date']); ?></p>
                        <p><strong>Diagnosis:</strong> <?php echo htmlspecialchars($record['diagnosis']); ?></p>
                        <p><strong>Treatment Plan:</strong> <?php echo htmlspecialchars($record['treatment_plan']); ?></p>
                        <p><strong>PCOS Score:</strong> <?php echo htmlspecialchars($record['pcos_score']); ?> (<?php echo htmlspecialchars($record['pcos_risk_level']); ?> risk)</p>
                        <hr>
                        <h5>Ultrasound Results</h5>
                        <ul>
                            <li>Follicle Count (Right): <?php echo htmlspecialchars($record['follicle_count_right']); ?></li>
                            <li>Follicle Count (Left): <?php echo htmlspecialchars($record['follicle_count_left']); ?></li>
                            <li>Follicle Size (Right): <?php echo htmlspecialchars($record['follicle_size_right']); ?></li>
                            <li>Follicle Size (Left): <?php echo htmlspecialchars($record['follicle_size_left']); ?></li>
                            <li>Endometrial Thickness: <?php echo htmlspecialchars($record['endometrial_thickness']); ?></li>
                            <li>Ovary Volume (Right): <?php echo htmlspecialchars($record['ovary_volume_right']); ?></li>
                            <li>Ovary Volume (Left): <?php echo htmlspecialchars($record['ovary_volume_left']); ?></li>
                            <li>Dominant Follicle (Right): <?php echo $record['dominant_follicle_right'] ? 'Yes' : 'No'; ?></li>
                            <li>Dominant Follicle (Left): <?php echo $record['dominant_follicle_left'] ? 'Yes' : 'No'; ?></li>
                            <li>Dominant Follicle Size: <?php echo htmlspecialchars($record['dominant_follicle_size']); ?></li>
                        </ul>
                        <hr>
                        <h5>Hormonal Levels</h5>
                        <ul>
                            <li>FSH: <?php echo htmlspecialchars($record['fsh_level']); ?></li>
                            <li>LH: <?php echo htmlspecialchars($record['lh_level']); ?></li>
                            <li>AMH: <?php echo htmlspecialchars($record['amh_level']); ?></li>
                            <li>Estradiol: <?php echo htmlspecialchars($record['estradiol_level']); ?></li>
                            <li>Progesterone: <?php echo htmlspecialchars($record['progesterone_level']); ?></li>
                            <li>Testosterone: <?php echo htmlspecialchars($record['testosterone_level']); ?></li>
                            <li>TSH: <?php echo htmlspecialchars($record['tsh_level']); ?></li>
                            <li>Prolactin: <?php echo htmlspecialchars($record['prolactin_level']); ?></li>
                        </ul>
                        <hr>
                        <h5>Metabolic Markers</h5>
                        <ul>
                            <li>Fasting Glucose: <?php echo htmlspecialchars($record['fasting_glucose']); ?></li>
                            <li>Fasting Insulin: <?php echo htmlspecialchars($record['fasting_insulin']); ?></li>
                            <li>HbA1c: <?php echo htmlspecialchars($record['hba1c']); ?></li>
                        </ul>
                        <hr>
                        <h5>PCOS Symptoms</h5>
                        <?php if ($symptoms): ?>
                            <ul>
                                <li>Irregular Cycles: <?php echo htmlspecialchars($symptoms['irregular_cycles']); ?></li>
                                <li>Hirsutism: <?php echo htmlspecialchars($symptoms['hirsutism']); ?></li>
                                <li>Acne: <?php echo htmlspecialchars($symptoms['acne']); ?></li>
                                <li>Hair Loss: <?php echo htmlspecialchars($symptoms['hair_loss']); ?></li>
                                <li>Weight Issues: <?php echo htmlspecialchars($symptoms['weight_issues']); ?></li>
                                <li>Skin Tags: <?php echo htmlspecialchars($symptoms['skin_tags']); ?></li>
                                <li>Dark Skin Patches: <?php echo htmlspecialchars($symptoms['dark_skin_patches']); ?></li>
                            </ul>
                        <?php else: ?>
                            <p>No PCOS symptoms recorded.</p>
                        <?php endif; ?>
                        <hr>
                        <p><strong>Notes:</strong> <?php echo nl2br(htmlspecialchars($record['notes'])); ?></p>
                    </div>
                </div>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>