<?php
require_once '../config.php';
requireRole('doctor');

$db = new Database();
$conn = $db->getConnection();

$patient_id = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;

if (!$patient_id) {
    header('Location: patients.php');
    exit;
}

// Get patient info
$stmt_patient = $conn->prepare("SELECT * FROM patients WHERE id = ?");
$stmt_patient->execute([$patient_id]);
$patient = $stmt_patient->fetch();

if (!$patient) {
    header('Location: patients.php');
    exit;
}

// Get all scans for this patient, linked to appointment date if available
$stmt_scans = $conn->prepare("
    SELECT s.*, a.appointment_date 
    FROM scan_uploads s
    LEFT JOIN appointments a ON s.appointment_id = a.id
    WHERE s.patient_id = ?
    ORDER BY s.upload_date DESC
");
$stmt_scans->execute([$patient_id]);
$scans = $stmt_scans->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Uploaded Scans for <?php echo safeHtmlspecialchars($patient['name']); ?> - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    <div class="container-fluid">
        <div class="row">
            <?php if (file_exists('includes/sidebar.php')) include 'includes/sidebar.php'; ?>
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Uploaded Scans for <?php echo safeHtmlspecialchars($patient['name']); ?></h1>
                    <a href="patients.php" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to Patients
                    </a>
                </div>

                <div class="card">
                    <div class="card-body">
                        <?php if (empty($scans)): ?>
                            <div class="alert alert-info text-center">
                                <i class="fas fa-info-circle me-2"></i>No scans have been uploaded by this patient.
                            </div>
                        <?php else: ?>
                            <div class="list-group">
                                <?php foreach ($scans as $scan): ?>
                                    <div class="list-group-item">
                                        <div class="d-flex w-100 justify-content-between">
                                            <h5 class="mb-1">
                                                <a href="../<?php echo safeHtmlspecialchars($scan['file_path']); ?>" target="_blank">
                                                    <i class="fas fa-file-medical me-2"></i><?php echo safeHtmlspecialchars($scan['file_name']); ?>
                                                </a>
                                            </h5>
                                            <small class="text-muted">Uploaded: <?php echo date('M j, Y', strtotime($scan['upload_date'])); ?></small>
                                        </div>
                                        <p class="mb-1"><?php echo safeHtmlspecialchars($scan['notes']); ?></p>
                                        <?php if ($scan['appointment_date']): ?>
                                            <small class="text-muted">Related Appointment: <?php echo date('M j, Y', strtotime($scan['appointment_date'])); ?></small>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>